# 基本计算器 II

<p>给你一个字符串表达式 <code>s</code> ，请你实现一个基本计算器来计算并返回它的值。</p>

<p>整数除法仅保留整数部分。</p>

<div class="original__bRMd">
<div>
<p> </p>

<p><strong>示例 1：</strong></p>

<pre>
<strong>输入：</strong>s = "3+2*2"
<strong>输出：</strong>7
</pre>

<p><strong>示例 2：</strong></p>

<pre>
<strong>输入：</strong>s = " 3/2 "
<strong>输出：</strong>1
</pre>

<p><strong>示例 3：</strong></p>

<pre>
<strong>输入：</strong>s = " 3+5 / 2 "
<strong>输出：</strong>5
</pre>

<p> </p>

<p><strong>提示：</strong></p>

<ul>
	<li><code>1 <= s.length <= 3 * 10<sup>5</sup></code></li>
	<li><code>s</code> 由整数和算符 <code>('+', '-', '*', '/')</code> 组成，中间由一些空格隔开</li>
	<li><code>s</code> 表示一个 <strong>有效表达式</strong></li>
	<li>表达式中的所有整数都是非负整数，且在范围 <code>[0, 2<sup>31</sup> - 1]</code> 内</li>
	<li>题目数据保证答案是一个 <strong>32-bit 整数</strong></li>
</ul>
</div>
</div>

<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    int res;
    string s1 = "3+2*2";
    res = sol.calculate(s1);
    cout << res;
    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    int calculate(string s)
    {
        int res = 0;
        stack<int> my_stack{};
        vector<char> my_vec{};
        for (auto x : s)
        {
            if (x != ' ')
                my_vec.push_back(x);
        }
        int start = 0;
        int end = 0;
        int tmp = 0;
        while (start != my_vec.size())
        {
            tmp = 0;
            for (int i = start; i < my_vec.size(); i++)
            {
                if (my_vec[i] >= '0')
                {
                    if (i == 0)
                    {
                        tmp = my_vec[i] - '0';
                    }
                    else if (my_vec[i - 1] == '+' || my_vec[i - 1] == '*' || my_vec[i - 1] == '/')
                        tmp = my_vec[i] - '0';
                    else if (my_vec[i - 1] == '-')
                        tmp = -1 * (my_vec[i] - '0');
                    else if (my_vec[i - 1] >= '0')
                    {
                        if (tmp >= 0)
                            tmp = tmp * 10 + (my_vec[i] - '0');
                        else
                            tmp = tmp * 10 - (my_vec[i] - '0');
                    }
                    if (i == my_vec.size() - 1)
                        end = i;
                }
                else
                {
                    end = i;
                    break;
                }
            }
            if (start == 0)
                my_stack.push(tmp);
            else
            {
                if (my_vec[start - 1] == '+' || my_vec[start - 1] == '-')
                    my_stack.push(tmp);
                else if (my_vec[start - 1] == '*')
                    my_stack.top() = my_stack.top() * tmp;
                else if (my_vec[start - 1] == '/')
                    my_stack.top() = my_stack.top() / tmp;
            }
            start = end + 1;
        }
        while (!my_stack.empty())
        {
            res = my_stack.top();
            my_stack.pop();
        }
        return res;
    }
};
```
## 选项


### A

```cpp
class Solution
{
public:
    int calculate(string s)
    {
        int ans = 0;
        int n = s.size();
        char ope = '+';
        stack<int> temp;
        int d = 0;
        int A;
        for (int i = 0; i < n; i++)
        {
            if (s[i] - '0' >= 0 && s[i] - '0' <= 9)
            {
                d = d * 10 + (s[i] - '0');
            }
            if ((s[i] < '0' && s[i] != ' ') || i == n - 1)
            {
                if (ope == '+')
                {
                    temp.push(d);
                }
                if (ope == '-')
                {
                    temp.push(-d);
                }
                if (ope == '*')
                {
                    A = temp.top() * d;
                    temp.pop();
                    temp.push(A);
                }
                if (ope == '/')
                {
                    A = temp.top() / d;
                    temp.pop();
                    temp.push(A);
                }
                ope = s[i];
                d = 0;
            }
        }
        while (!temp.empty())
        {
            ans += temp.top();
            temp.pop();
        }
        return ans;
    }
};
```

### B

```cpp
class Solution
{
public:
    int calculate(string s)
    {
        stack<char> fuhao;
        stack<long> conclude;
        int i = 0, len = s.length();
        while (i < len)
        {
            if (s[i] == ' ')
                i++;
            else if (s[i] >= '0' && s[i] <= '9')
            {
                long x = s[i] - '0';
                i++;
                while (i < len && s[i] >= '0' && s[i] <= '9')
                {
                    x = x * 10 + s[i] - '0';
                    i++;
                }
                conclude.push(x);
            }
            else
            {
                while (!fuhao.empty() && (fuhao.top() == '*' || fuhao.top() == '/' || s[i] == '+' || s[i] == '-'))
                {
                    long x = conclude.top();
                    conclude.pop();
                    long y = conclude.top();
                    conclude.pop();
                    if (fuhao.top() == '+')
                        conclude.push(y + x);
                    else if (fuhao.top() == '-')
                        conclude.push(y - x);
                    else if (fuhao.top() == '*')
                        conclude.push(y * x);
                    else
                        conclude.push(y / x);
                    fuhao.pop();
                }
                fuhao.push(s[i]);
                i++;
            }
        }
        while (!fuhao.empty())
        {
            long x = conclude.top();
            conclude.pop();
            long y = conclude.top();
            conclude.pop();
            if (fuhao.top() == '+')
                conclude.push(y + x);
            else if (fuhao.top() == '-')
                conclude.push(y - x);
            else if (fuhao.top() == '*')
                conclude.push(y * x);
            else
                conclude.push(y / x);
            fuhao.pop();
        }
        return conclude.top();
    }
};
```

### C

```cpp
class Solution
{
public:
    int calculate(string s)
    {
        vector<int> stk;
        char preSign = '+';
        int num = 0;
        int n = s.length();
        for (int i = 0; i < n; ++i)
        {
            if (isdigit(s[i]))
            {
                num = num * 10 + int(s[i] - '0');
            }
            if (!isdigit(s[i]) && s[i] != ' ' || i == n - 1)
            {
                switch (preSign)
                {
                case '+':
                    stk.push_back(num);
                    break;
                case '-':
                    stk.push_back(-num);
                    break;
                case '*':
                    stk.back() *= num;
                    break;
                default:
                    stk.back() /= num;
                }
                preSign = s[i];
                num = 0;
            }
        }
        return accumulate(stk.begin(), stk.end(), 0);
    }
};
```
